clc;
clear all;
close all;
fclose all;


ref=wavread('swisha.wav');

signal=wavread('bar.wav');

len=2*length(ref)

slen=length(signal)

reft=fft(ref,len);

lb=signal(1:slen,2);
imp=signal(1:slen,1);

lbt=fft(lb,len);
impt=fft(imp,len);

lbtd=lbt ./ reft;

imptd=impt ./ reft;

close all;

f=(0:len/2)*22050/(len/2);
f=f';



subplot(3,1,1);

imptdb=abs(imptd(1:len/2+1));
t=max(imptdb);
imptdb =imptdb /t;
imptdb=max(imptdb, .001);
imptdb=20*log10(imptdb);
plot(f,imptdb);

imptdb=abs(imptd(1:len/2+1));  % now average the amplitude spectrum

[bb,aa]=butter(7, 1/256); % 256 line average, more or less.

imptdb=filtfilt(bb,aa,imptdb);
t=max(imptdb);
imptdb =imptdb /t;
imptdb=max(imptdb, .001);
imptdb=20*log10(imptdb);

subplot(3,1,2);
plot(f,imptdb);

%find center of impulse response

temp(1:len)=0;
temp(1:len/2+1)=imptd(1:len/2+1);
temp=abs(ifft(temp));

subplot(3,1,3)

[junk,center]=max(temp);

decrate=128;

slen=len/decrate;

if (center < slen/2+1)
	center=slen/2+1;
end

wind=hann(slen);

impres=real(ifft(imptd));

imps=impres( (center-slen/2+1):(center+slen/2) ) .* wind;
impsa=abs(fft(imps));
t=max(impsa);
impsa=impsa/t;
impsdb=impsa(1:slen/2+1);
impsdb=max(impsdb,.001);
impsdb=20*log10(impsdb);
plot(f(1:decrate:len/2+1)',impsdb);


