clear all;
close all;

x=wavread('swisha.wav');
len=2*length(x); # have to allow for filter ringing, so double length.

[bb,aa]=butter(5,.125);

xm=[ [0 0 0 0 0 0 0 0 0]'; x]; # we delay the probe 10 samples just like before

y=filter(bb,aa,xm);

yt=fft(y,len);
xt=fft(x,len);

zt=yt ./ xt;

z=ifft(zt);
z=real(z); # get rid of residues from calculation error

subplot(4,1,1)
plot(xm);
subplot(4,1,2)
plot(y)
subplot(4,1,3)
plot( abs(zt(1:len/2+1)))  # look, batman, frequency response to ridiculous accuracy
subplot(4,1,4)
plot(z(1:1024)); # shazam!

